@ECHO OFF
REM
REM Check for time parameters
REM
IF "%1"=="" GOTO noparam
IF "%2"=="" GOTO noparam

REM
REM Set the variables 'time-start' & 'time_end' as per command line parameters
REM Get current time and store it in the variable, 'time_now'
REM
SET time_start=%1:00:00
SET time_end=%2:00:00
SET "time_now=%time: =0%"

REM
REM Test to see if 'time_now' is less than 'time_start' (the first IF statement)
REM or greater than 'time_end' (the second IF statement) and UNBLOCK if they are.
REM
IF "%time_now%" LSS "%time_start%" GOTO unblocksites
IF "%time_now%" GEQ "%time_end%" GOTO unblocksites

:blocksites
    REM
    REM Block Sites. This is the default action if neither IF statement above
    REM has been actioned. Once done, exit batch file. 
    REM
    FOR /f "tokens=*" %%a IN (block.txt) DO CALL :processline %%a
    GOTO :eof

:unblocksites
    REM
    REM Unblock Sites. This occurs if either IF statement above has been actioned.
    REM Once done, exit batch file. 
    REM
    COPY hosts.aok %SystemRoot%\System32\drivers\etc\hosts
    GOTO :eof

:processline
    REM
    REM Adds lines of blocked sites to hosts file
    REM
    ECHO 127.0.0.1	%* >> C:\Windows\System32\drivers\etc\hosts
    GOTO :eof

:noparam
    CLS
    ECHO.
    ECHO.
    ECHO **************************************************************************************
    ECHO *
    ECHO * You Need To Supply Start And End Time Parameters in the form XX:XX (24 hour clock)
    ECHO * For Example (to block distracting sites from 10am to 6pm):
    ECHO *     antidistract 10:00 18:00
    ECHO *
    ECHO **************************************************************************************
    ECHO.
    ECHO.
    pause
    GOTO :eof